/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// note  conv functions

#include <StdAfx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"


HRESULT TestDrawingNoteCF() 
{
	START_METHOD("Note")
	
	HRESULT status = CONV_SUCCESS ;
	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication) ;
	CHECK_RETURN_STATUS(status)

	IGraphicDocument *activeGraphicDoc = NULL;
	IDrawingDocument *activeDraw = NULL;

	status = GetActiveDrawingDoc(&activeDraw, &activeGraphicDoc);
	CHECK_RETURN_STATUS(status)

	IDesign *pDesign= NULL;

	AfxMessageBox("Select a View in the Drawing");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)

	ISet *localObjectSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Graphic"), &localObjectSet);
	CHECK_RETURN_STATUS(status)

	IIt *pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(localObjectSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	IDispatch *pGraph1 = NULL;
	status = pObjectIt->start(&pGraph1);
	CHECK_RETURN_STATUS(status)
	
	IView *pView1 = CAST(IView, pGraph1);

	status = pView1->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox ("Select a Drawing Feature in the active View");

	status = CommitToProDESKTOP("Selection", TRUE);
	CHECK_RETURN_STATUS(status)
	
	localObjectSet = NULL;
	status = activeGraphicDoc->GetSelection(GetBSTR("Graphic"), &localObjectSet);
	CHECK_RETURN_STATUS(status)

	pObjectIt = NULL;
	status = (GetCLASS(It))->CreateAObjectIt(localObjectSet, &pObjectIt);
	CHECK_RETURN_STATUS(status)

	pGraph1 = NULL;
	status = pObjectIt->start(&pGraph1);
	CHECK_RETURN_STATUS(status)
	
	INote *pNote = NULL;
	status = Note(pDesign, activeDraw, CAST(IGraphic, pGraph1), &pNote);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Note");
	CHECK_RETURN_STATUS(status)

	END_METHOD("Note")
}
